#ifndef ROBOTCONTROLLERAGENT_H_
#define ROBOTCONTROLLERAGENT_H_

#include "IAgent.h"
#include "IFilter.h"
#include <list>

using namespace std;
namespace Communication
{

class RobotControllerAgent : public Communication::IAgent
{
public:
	RobotControllerAgent();
	RobotControllerAgent(int port, string ip, bool syncmode, double broadcastint, list <int>robotids, string key);
	virtual ~RobotControllerAgent();
	int GetPort();
	string GetIP();
	bool GetSyncMode();
	bool GetSyncFlag();
	int GetIterationSync();
	string GetKey();
	list <int> GetRobotIds();
	double GetTimeStamp();
	double GetBroadcastInterval();
	void SetPort(int port);
	void SetIP(string ip);
	void SetKey(string key);
	void SetSyncMode(bool syncmode);
	void SetSyncFlag(bool value);
	void SetIterationSync(int value);
	void SetRobotIds(list <int> robotids);
	void SetTimeStamp(double value);
	void SetBroadcastInterval(double value);
	string FilterData(string data);
	DataAgent* GetDataAgent();
private:
	int port;
	string ip;
	bool syncmode;
	bool syncflag;
	int iterationsync;
	string agentkey;
	IFilter *filter;
	list <int> robotIds;
	double timestamp;
	double broadcastinterval;
};

}

#endif /*ROBOTCONTROLLERAGENT_H_*/
